@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The observed state of logical networks
 * @property errorCode LogicalNetwork provisioning error code
 * @property errorMessage Descriptive error message
 * @property provisioningStatus
 */
public data class LogicalNetworkStatusResponse(
    public val errorCode: String? = null,
    public val errorMessage: String? = null,
    public val provisioningStatus: LogicalNetworkStatusResponseProvisioningStatus? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.LogicalNetworkStatusResponse): LogicalNetworkStatusResponse = LogicalNetworkStatusResponse(
            errorCode = javaType.errorCode().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.LogicalNetworkStatusResponseProvisioningStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
