@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The NIC Detail of a device.
 * @property adapterName Adapter Name of NIC
 * @property componentId Component Id of NIC
 * @property defaultGateway Default Gateway of NIC
 * @property defaultIsolationId Default Isolation of Management NIC
 * @property dnsServers DNS Servers for NIC
 * @property driverVersion Driver Version of NIC
 * @property interfaceDescription Interface Description of NIC
 * @property ip4Address Subnet Mask of NIC
 * @property subnetMask Subnet Mask of NIC
 */
public data class NicDetailResponse(
    public val adapterName: String,
    public val componentId: String? = null,
    public val defaultGateway: String? = null,
    public val defaultIsolationId: String? = null,
    public val dnsServers: List<String>? = null,
    public val driverVersion: String? = null,
    public val interfaceDescription: String? = null,
    public val ip4Address: String? = null,
    public val subnetMask: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.NicDetailResponse): NicDetailResponse = NicDetailResponse(
            adapterName = javaType.adapterName(),
            componentId = javaType.componentId().map({ args0 -> args0 }).orElse(null),
            defaultGateway = javaType.defaultGateway().map({ args0 -> args0 }).orElse(null),
            defaultIsolationId = javaType.defaultIsolationId().map({ args0 -> args0 }).orElse(null),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            driverVersion = javaType.driverVersion().map({ args0 -> args0 }).orElse(null),
            interfaceDescription = javaType.interfaceDescription().map({ args0 -> args0 }).orElse(null),
            ip4Address = javaType.ip4Address().map({ args0 -> args0 }).orElse(null),
            subnetMask = javaType.subnetMask().map({ args0 -> args0 }).orElse(null),
        )
    }
}
