@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The Observability of AzureStackHCI Cluster.
 * @property episodicDataUpload When set to true, collects log data to facilitate quicker issue resolution.
 * @property euLocation Location of your cluster. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to false results in all data sent to Microsoft to be stored outside of the EU.
 * @property streamingDataClient Enables telemetry data to be sent to Microsoft
 */
public data class ObservabilityResponse(
    public val episodicDataUpload: Boolean? = null,
    public val euLocation: Boolean? = null,
    public val streamingDataClient: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.ObservabilityResponse): ObservabilityResponse = ObservabilityResponse(
            episodicDataUpload = javaType.episodicDataUpload().map({ args0 -> args0 }).orElse(null),
            euLocation = javaType.euLocation().map({ args0 -> args0 }).orElse(null),
            streamingDataClient = javaType.streamingDataClient().map({ args0 -> args0 }).orElse(null),
        )
    }
}
