@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Status of Arc Extension for a particular node in HCI Cluster.
 * @property extension Fully qualified resource ID for the particular Arc Extension on this node.
 * @property instanceView The extension instance view.
 * @property name Name of the node in HCI Cluster.
 * @property state State of Arc Extension in this node.
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class PerNodeExtensionStateResponse(
    public val extension: String,
    public val instanceView: ExtensionInstanceViewResponse,
    public val name: String,
    public val state: String,
    public val typeHandlerVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.PerNodeExtensionStateResponse): PerNodeExtensionStateResponse = PerNodeExtensionStateResponse(
            extension = javaType.extension(),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtensionInstanceViewResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            state = javaType.state(),
            typeHandlerVersion = javaType.typeHandlerVersion(),
        )
    }
}
