@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Status of Arc agent for a particular node in HCI Cluster.
 * @property arcInstance Fully qualified resource ID for the Arc agent of this node.
 * @property name Name of the Node in HCI Cluster
 * @property state State of Arc agent in this node.
 */
public data class PerNodeStateResponse(
    public val arcInstance: String,
    public val name: String,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.PerNodeStateResponse): PerNodeStateResponse = PerNodeStateResponse(
            arcInstance = javaType.arcInstance(),
            name = javaType.name(),
            state = javaType.state(),
        )
    }
}
