@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The PhysicalNodes of a cluster.
 * @property ipv4Address The IPv4 address assigned to each physical server on your Azure Stack HCI cluster.
 * @property name NETBIOS name of each physical server on your Azure Stack HCI cluster.
 */
public data class PhysicalNodesResponse(
    public val ipv4Address: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.PhysicalNodesResponse): PhysicalNodesResponse = PhysicalNodesResponse(
            ipv4Address = javaType.ipv4Address().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
