@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Route table resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property name Resource name.
 * @property routes Collection of routes contained within a route table.
 * @property type Resource type.
 */
public data class RouteTableResponse(
    public val etag: String,
    public val name: String,
    public val routes: List<RouteResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.RouteTableResponse): RouteTableResponse = RouteTableResponse(
            etag = javaType.etag(),
            name = javaType.name(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.RouteResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
