@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Security compliance properties of the resource
 * @property dataAtRestEncrypted Indicates whether data at-rest encryption is enabled on Azure Stack HCI clustered volumes.
 * @property dataInTransitProtected Indicates whether HCI cluster has data in-transit protection.
 * @property lastUpdated Time in UTC when compliance status was last updated.
 * @property securedCoreCompliance Indicates whether HCI hosts meets secured-core server requirements.
 * @property wdacCompliance Indicates whether HCI hosts have enforced consistent Windows Defender Application Control.
 */
public data class SecurityComplianceStatusResponse(
    public val dataAtRestEncrypted: String,
    public val dataInTransitProtected: String,
    public val lastUpdated: String,
    public val securedCoreCompliance: String,
    public val wdacCompliance: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.SecurityComplianceStatusResponse): SecurityComplianceStatusResponse = SecurityComplianceStatusResponse(
            dataAtRestEncrypted = javaType.dataAtRestEncrypted(),
            dataInTransitProtected = javaType.dataInTransitProtected(),
            lastUpdated = javaType.lastUpdated(),
            securedCoreCompliance = javaType.securedCoreCompliance(),
            wdacCompliance = javaType.wdacCompliance(),
        )
    }
}
