@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The SecuritySettings of AzureStackHCI Cluster.
 * @property bitlockerBootVolume When set to true, BitLocker XTS_AES 256-bit encryption is enabled for all data-at-rest on the OS volume of your Azure Stack HCI cluster. This setting is TPM-hardware dependent.
 * @property bitlockerDataVolumes When set to true, BitLocker XTS-AES 256-bit encryption is enabled for all data-at-rest on your Azure Stack HCI cluster shared volumes.
 * @property credentialGuardEnforced When set to true, Credential Guard is enabled.
 * @property driftControlEnforced When set to true, the security baseline is re-applied regularly.
 * @property drtmProtection By default, Secure Boot is enabled on your Azure HCI cluster. This setting is hardware dependent.
 * @property hvciProtection By default, Hypervisor-protected Code Integrity is enabled on your Azure HCI cluster.
 * @property sideChannelMitigationEnforced When set to true, all the side channel mitigations are enabled
 * @property smbClusterEncryption When set to true, cluster east-west traffic is encrypted.
 * @property smbSigningEnforced When set to true, the SMB default instance requires sign in for the client and server services.
 * @property wdacEnforced WDAC is enabled by default and limits the applications and the code that you can run on your Azure Stack HCI cluster.
 */
public data class SecuritySettingsResponse(
    public val bitlockerBootVolume: Boolean? = null,
    public val bitlockerDataVolumes: Boolean? = null,
    public val credentialGuardEnforced: Boolean? = null,
    public val driftControlEnforced: Boolean? = null,
    public val drtmProtection: Boolean? = null,
    public val hvciProtection: Boolean? = null,
    public val sideChannelMitigationEnforced: Boolean? = null,
    public val smbClusterEncryption: Boolean? = null,
    public val smbSigningEnforced: Boolean? = null,
    public val wdacEnforced: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.SecuritySettingsResponse): SecuritySettingsResponse = SecuritySettingsResponse(
            bitlockerBootVolume = javaType.bitlockerBootVolume().map({ args0 -> args0 }).orElse(null),
            bitlockerDataVolumes = javaType.bitlockerDataVolumes().map({ args0 -> args0 }).orElse(null),
            credentialGuardEnforced = javaType.credentialGuardEnforced().map({ args0 -> args0 }).orElse(null),
            driftControlEnforced = javaType.driftControlEnforced().map({ args0 -> args0 }).orElse(null),
            drtmProtection = javaType.drtmProtection().map({ args0 -> args0 }).orElse(null),
            hvciProtection = javaType.hvciProtection().map({ args0 -> args0 }).orElse(null),
            sideChannelMitigationEnforced = javaType.sideChannelMitigationEnforced().map({ args0 ->
                args0
            }).orElse(null),
            smbClusterEncryption = javaType.smbClusterEncryption().map({ args0 -> args0 }).orElse(null),
            smbSigningEnforced = javaType.smbSigningEnforced().map({ args0 -> args0 }).orElse(null),
            wdacEnforced = javaType.wdacEnforced().map({ args0 -> args0 }).orElse(null),
        )
    }
}
