@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The observed state of storage containers
 * @property availableSizeMB Amount of space available on the disk in MB
 * @property containerSizeMB Total size of the disk in MB
 * @property errorCode StorageContainer provisioning error code
 * @property errorMessage Descriptive error message
 * @property provisioningStatus
 */
public data class StorageContainerStatusResponse(
    public val availableSizeMB: Double? = null,
    public val containerSizeMB: Double? = null,
    public val errorCode: String? = null,
    public val errorMessage: String? = null,
    public val provisioningStatus: StorageContainerStatusResponseProvisioningStatus? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.StorageContainerStatusResponse): StorageContainerStatusResponse = StorageContainerStatusResponse(
            availableSizeMB = javaType.availableSizeMB().map({ args0 -> args0 }).orElse(null),
            containerSizeMB = javaType.containerSizeMB().map({ args0 -> args0 }).orElse(null),
            errorCode = javaType.errorCode().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.StorageContainerStatusResponseProvisioningStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
