@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The StorageNetworks of a cluster.
 * @property name Name of the storage network.
 * @property networkAdapterName Name of the storage network adapter.
 * @property vlanId ID specified for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic.
 */
public data class StorageNetworksResponse(
    public val name: String? = null,
    public val networkAdapterName: String? = null,
    public val vlanId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.StorageNetworksResponse): StorageNetworksResponse = StorageNetworksResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            networkAdapterName = javaType.networkAdapterName().map({ args0 -> args0 }).orElse(null),
            vlanId = javaType.vlanId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
