@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Storage config of AzureStackHCI Cluster.
 * @property configurationMode By default, this mode is set to Express and your storage is configured as per best practices based on the number of nodes in the cluster. Allowed values are 'Express','InfraOnly', 'KeepStorage'
 */
public data class StorageResponse(
    public val configurationMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.StorageResponse): StorageResponse = StorageResponse(
            configurationMode = javaType.configurationMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
