@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The ValidationStatus of AzureStackHCI Cluster.
 * @property status Status of AzureStackHCI Cluster Deployment.
 * @property steps List of steps of AzureStackHCI Cluster Deployment.
 */
public data class ValidationStatusResponse(
    public val status: String,
    public val steps: List<StepResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.ValidationStatusResponse): ValidationStatusResponse = ValidationStatusResponse(
            status = javaType.status(),
            steps = javaType.steps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.StepResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
