@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * LinuxConfiguration - linux specific configuration values for the virtual machine instance
 * @property disablePasswordAuthentication DisablePasswordAuthentication - whether password authentication should be disabled
 * @property provisionVMAgent Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation process.
 * @property provisionVMConfigAgent Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
 * @property ssh Specifies the ssh key configuration for a Linux OS.
 */
public data class VirtualMachineInstancePropertiesResponseLinuxConfiguration(
    public val disablePasswordAuthentication: Boolean? = null,
    public val provisionVMAgent: Boolean? = null,
    public val provisionVMConfigAgent: Boolean? = null,
    public val ssh: SshConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachineInstancePropertiesResponseLinuxConfiguration): VirtualMachineInstancePropertiesResponseLinuxConfiguration =
            VirtualMachineInstancePropertiesResponseLinuxConfiguration(
                disablePasswordAuthentication = javaType.disablePasswordAuthentication().map({ args0 ->
                    args0
                }).orElse(null),
                provisionVMAgent = javaType.provisionVMAgent().map({ args0 -> args0 }).orElse(null),
                provisionVMConfigAgent = javaType.provisionVMConfigAgent().map({ args0 -> args0 }).orElse(null),
                ssh = javaType.ssh().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.SshConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
