@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * StorageProfile - contains information about the disks and storage information for the virtual machine instance
 * @property dataDisks adds data disks to the virtual machine instance
 * @property imageReference Which Image to use for the virtual machine instance
 * @property osDisk VHD to attach as OS disk
 * @property vmConfigStoragePathId Id of the storage container that hosts the VM configuration file
 */
public data class VirtualMachineInstancePropertiesResponseStorageProfile(
    public val dataDisks: List<VirtualMachineInstancePropertiesResponseDataDisks>? = null,
    public val imageReference: VirtualMachineInstancePropertiesResponseImageReference? = null,
    public val osDisk: VirtualMachineInstancePropertiesResponseOsDisk? = null,
    public val vmConfigStoragePathId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachineInstancePropertiesResponseStorageProfile): VirtualMachineInstancePropertiesResponseStorageProfile =
            VirtualMachineInstancePropertiesResponseStorageProfile(
                dataDisks = javaType.dataDisks().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseDataDisks.Companion.toKotlin(args0)
                    })
                }),
                imageReference = javaType.imageReference().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseImageReference.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                osDisk = javaType.osDisk().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseOsDisk.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                vmConfigStoragePathId = javaType.vmConfigStoragePathId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
