@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Windows Configuration for the virtual machine instance
 * @property enableAutomaticUpdates Whether to EnableAutomaticUpdates on the machine
 * @property provisionVMAgent Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation process.
 * @property provisionVMConfigAgent Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
 * @property ssh Specifies the ssh key configuration for Windows OS.
 * @property timeZone TimeZone for the virtual machine instance
 */
public data class VirtualMachineInstancePropertiesResponseWindowsConfiguration(
    public val enableAutomaticUpdates: Boolean? = null,
    public val provisionVMAgent: Boolean? = null,
    public val provisionVMConfigAgent: Boolean? = null,
    public val ssh: SshConfigurationResponse? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachineInstancePropertiesResponseWindowsConfiguration): VirtualMachineInstancePropertiesResponseWindowsConfiguration =
            VirtualMachineInstancePropertiesResponseWindowsConfiguration(
                enableAutomaticUpdates = javaType.enableAutomaticUpdates().map({ args0 -> args0 }).orElse(null),
                provisionVMAgent = javaType.provisionVMAgent().map({ args0 -> args0 }).orElse(null),
                provisionVMConfigAgent = javaType.provisionVMConfigAgent().map({ args0 -> args0 }).orElse(null),
                ssh = javaType.ssh().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.SshConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
            )
    }
}
