@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * OsProfile - describes the configuration of the operating system and sets login data
 * @property adminUsername AdminUsername - admin username
 * @property computerName ComputerName - name of the compute
 * @property linuxConfiguration LinuxConfiguration - linux specific configuration values for the virtual machine
 * @property osType OsType - string specifying whether the OS is Linux or Windows
 * @property windowsConfiguration Windows Configuration for the virtual machine
 */
public data class VirtualMachinePropertiesResponseOsProfile(
    public val adminUsername: String? = null,
    public val computerName: String? = null,
    public val linuxConfiguration: VirtualMachinePropertiesResponseLinuxConfiguration? = null,
    public val osType: String? = null,
    public val windowsConfiguration: VirtualMachinePropertiesResponseWindowsConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachinePropertiesResponseOsProfile): VirtualMachinePropertiesResponseOsProfile = VirtualMachinePropertiesResponseOsProfile(
            adminUsername = javaType.adminUsername().map({ args0 -> args0 }).orElse(null),
            computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
            linuxConfiguration = javaType.linuxConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseLinuxConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            windowsConfiguration = javaType.windowsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseWindowsConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
