@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keyData KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
 * @property path Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
 */
public data class VirtualMachinePropertiesResponsePublicKeysPublicKeys(
    public val keyData: String? = null,
    public val path: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachinePropertiesResponsePublicKeysPublicKeys): VirtualMachinePropertiesResponsePublicKeysPublicKeys =
            VirtualMachinePropertiesResponsePublicKeysPublicKeys(
                keyData = javaType.keyData().map({ args0 -> args0 }).orElse(null),
                path = javaType.path().map({ args0 -> args0 }).orElse(null),
            )
    }
}
