@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * StorageProfile - contains information about the disks and storage information for the virtual machine
 * @property dataDisks adds data disks to the virtual machine
 * @property imageReference Which Image to use for the virtual machine
 * @property osDisk VHD to attach as OS disk
 * @property vmConfigStoragePathId Id of the storage container that hosts the VM configuration file
 */
public data class VirtualMachinePropertiesResponseStorageProfile(
    public val dataDisks: List<VirtualMachinePropertiesResponseDataDisks>? = null,
    public val imageReference: VirtualMachinePropertiesResponseImageReference? = null,
    public val osDisk: VirtualMachinePropertiesResponseOsDisk? = null,
    public val vmConfigStoragePathId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachinePropertiesResponseStorageProfile): VirtualMachinePropertiesResponseStorageProfile =
            VirtualMachinePropertiesResponseStorageProfile(
                dataDisks = javaType.dataDisks().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseDataDisks.Companion.toKotlin(args0)
                    })
                }),
                imageReference = javaType.imageReference().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseImageReference.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                osDisk = javaType.osDisk().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseOsDisk.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                vmConfigStoragePathId = javaType.vmConfigStoragePathId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
