@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of the VM Config Agent running on the virtual machine.
 * @property statuses The resource status information.
 * @property vmVMConfigAgentVersion The VM Config Agent full version.
 */
public data class VirtualMachineVMConfigAgentInstanceViewResponse(
    public val statuses: List<InstanceViewStatusResponse>? = null,
    public val vmVMConfigAgentVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachineVMConfigAgentInstanceViewResponse): VirtualMachineVMConfigAgentInstanceViewResponse =
            VirtualMachineVMConfigAgentInstanceViewResponse(
                statuses = javaType.statuses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                    })
                }),
                vmVMConfigAgentVersion = javaType.vmVMConfigAgentVersion().map({ args0 -> args0 }).orElse(null),
            )
    }
}
