@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Route is associated with a subnet.
 * @property addressPrefix AddressPrefix - The destination CIDR to which the route applies.
 * @property name Name - name of the subnet
 * @property nextHopIpAddress NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
 */
public data class VirtualNetworkPropertiesResponseRoutes(
    public val addressPrefix: String? = null,
    public val name: String? = null,
    public val nextHopIpAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualNetworkPropertiesResponseRoutes): VirtualNetworkPropertiesResponseRoutes = VirtualNetworkPropertiesResponseRoutes(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nextHopIpAddress = javaType.nextHopIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
