@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Subnet subnet in a virtual network resource.
 * @property addressPrefix Cidr for this subnet - IPv4, IPv6
 * @property addressPrefixes AddressPrefixes - List of address prefixes for the subnet.
 * @property ipAllocationMethod IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
 * @property ipConfigurationReferences IPConfigurationReferences - list of IPConfigurationReferences
 * @property ipPools network associated pool of IP Addresses
 * @property name Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property routeTable RouteTable for the subnet
 * @property vlan Vlan to use for the subnet
 */
public data class VirtualNetworkPropertiesResponseSubnets(
    public val addressPrefix: String? = null,
    public val addressPrefixes: List<String>? = null,
    public val ipAllocationMethod: String? = null,
    public val ipConfigurationReferences: List<VirtualNetworkPropertiesResponseIpConfigurationReferences>? = null,
    public val ipPools: List<IPPoolResponse>? = null,
    public val name: String? = null,
    public val routeTable: VirtualNetworkPropertiesResponseRouteTable? = null,
    public val vlan: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualNetworkPropertiesResponseSubnets): VirtualNetworkPropertiesResponseSubnets = VirtualNetworkPropertiesResponseSubnets(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            addressPrefixes = javaType.addressPrefixes().map({ args0 -> args0 }),
            ipAllocationMethod = javaType.ipAllocationMethod().map({ args0 -> args0 }).orElse(null),
            ipConfigurationReferences = javaType.ipConfigurationReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkPropertiesResponseIpConfigurationReferences.Companion.toKotlin(args0)
                })
            }),
            ipPools = javaType.ipPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.IPPoolResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            routeTable = javaType.routeTable().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkPropertiesResponseRouteTable.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vlan = javaType.vlan().map({ args0 -> args0 }).orElse(null),
        )
    }
}
