@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The VirtualSwitchConfigurationOverrides of a cluster.
 * @property enableIov Enable IoV for Virtual Switch
 * @property loadBalancingAlgorithm Load Balancing Algorithm for Virtual Switch
 */
public data class VirtualSwitchConfigurationOverridesResponse(
    public val enableIov: String? = null,
    public val loadBalancingAlgorithm: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualSwitchConfigurationOverridesResponse): VirtualSwitchConfigurationOverridesResponse = VirtualSwitchConfigurationOverridesResponse(
            enableIov = javaType.enableIov().map({ args0 -> args0 }).orElse(null),
            loadBalancingAlgorithm = javaType.loadBalancingAlgorithm().map({ args0 -> args0 }).orElse(null),
        )
    }
}
