@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.baremetalinfrastructure.kotlin.inputs

import com.pulumi.azurenative.baremetalinfrastructure.inputs.StorageBillingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the billing related details of the AzureBareMetalStorageInstance.
 * @property azureBareMetalStorageInstanceSize the SKU type that is provisioned
 * @property billingMode the billing mode for the storage instance
 */
public data class StorageBillingPropertiesArgs(
    public val azureBareMetalStorageInstanceSize: Output<String>? = null,
    public val billingMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.baremetalinfrastructure.inputs.StorageBillingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.baremetalinfrastructure.inputs.StorageBillingPropertiesArgs =
        com.pulumi.azurenative.baremetalinfrastructure.inputs.StorageBillingPropertiesArgs.builder()
            .azureBareMetalStorageInstanceSize(
                azureBareMetalStorageInstanceSize?.applyValue({ args0 ->
                    args0
                }),
            )
            .billingMode(billingMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageBillingPropertiesArgs].
 */
@PulumiTagMarker
public class StorageBillingPropertiesArgsBuilder internal constructor() {
    private var azureBareMetalStorageInstanceSize: Output<String>? = null

    private var billingMode: Output<String>? = null

    /**
     * @param value the SKU type that is provisioned
     */
    @JvmName("djswdimyalmdevnm")
    public suspend fun azureBareMetalStorageInstanceSize(`value`: Output<String>) {
        this.azureBareMetalStorageInstanceSize = value
    }

    /**
     * @param value the billing mode for the storage instance
     */
    @JvmName("ninancbigcmoxrfw")
    public suspend fun billingMode(`value`: Output<String>) {
        this.billingMode = value
    }

    /**
     * @param value the SKU type that is provisioned
     */
    @JvmName("kjmoyhhhwveluril")
    public suspend fun azureBareMetalStorageInstanceSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBareMetalStorageInstanceSize = mapped
    }

    /**
     * @param value the billing mode for the storage instance
     */
    @JvmName("fpwikwsemjkkfmyo")
    public suspend fun billingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingMode = mapped
    }

    internal fun build(): StorageBillingPropertiesArgs = StorageBillingPropertiesArgs(
        azureBareMetalStorageInstanceSize = azureBareMetalStorageInstanceSize,
        billingMode = billingMode,
    )
}
