@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * described the storage properties of the azure baremetalstorage instance
 * @property generation the kind of storage instance
 * @property hardwareType the hardware type of the storage instance
 * @property offeringType the offering type for which the resource is getting provisioned
 * @property provisioningState State of provisioning of the AzureBareMetalStorageInstance
 * @property storageBillingProperties the billing related information for the resource
 * @property storageType the storage protocol for which the resource is getting provisioned
 * @property workloadType the workload for which the resource is getting provisioned
 */
public data class StoragePropertiesResponse(
    public val generation: String? = null,
    public val hardwareType: String? = null,
    public val offeringType: String? = null,
    public val provisioningState: String? = null,
    public val storageBillingProperties: StorageBillingPropertiesResponse? = null,
    public val storageType: String? = null,
    public val workloadType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.baremetalinfrastructure.outputs.StoragePropertiesResponse): StoragePropertiesResponse = StoragePropertiesResponse(
            generation = javaType.generation().map({ args0 -> args0 }).orElse(null),
            hardwareType = javaType.hardwareType().map({ args0 -> args0 }).orElse(null),
            offeringType = javaType.offeringType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            storageBillingProperties = javaType.storageBillingProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs.StorageBillingPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageType = javaType.storageType().map({ args0 -> args0 }).orElse(null),
            workloadType = javaType.workloadType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
