@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.azurenative.batch.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Contains information about an application in a Batch account.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2017-09-01, 2023-11-01, 2024-02-01.
 * ## Example Usage
 * ### ApplicationCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.Batch.Application("application", new()
 *     {
 *         AccountName = "sampleacct",
 *         AllowUpdates = false,
 *         ApplicationName = "app1",
 *         DisplayName = "myAppName",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewApplication(ctx, "application", &batch.ApplicationArgs{
 * 			AccountName:       pulumi.String("sampleacct"),
 * 			AllowUpdates:      pulumi.Bool(false),
 * 			ApplicationName:   pulumi.String("app1"),
 * 			DisplayName:       pulumi.String("myAppName"),
 * 			ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Application;
 * import com.pulumi.azurenative.batch.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .accountName("sampleacct")
 *             .allowUpdates(false)
 *             .applicationName("app1")
 *             .displayName("myAppName")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:batch:Application app1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.azurenative.batch.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * A value indicating whether packages within the application may be overwritten using the same version string.
     */
    public val allowUpdates: Output<Boolean>?
        get() = javaResource.allowUpdates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The package to use if a client requests the application but does not specify a version. This property can only be set to the name of an existing package.
     */
    public val defaultVersion: Output<String>?
        get() = javaResource.defaultVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name for the application.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ETag of the resource, used for concurrency statements.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.batch.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.azurenative.batch.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
