@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApplicationPackage].
 */
@PulumiTagMarker
public class ApplicationPackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationPackageArgs = ApplicationPackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationPackageArgsBuilder.() -> Unit) {
        val builder = ApplicationPackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationPackage {
        val builtJavaResource = com.pulumi.azurenative.batch.ApplicationPackage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApplicationPackage(builtJavaResource)
    }
}

/**
 * An application package which represents a particular version of an application.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2017-09-01, 2023-11-01, 2024-02-01.
 * ## Example Usage
 * ### ApplicationPackageCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationPackage = new AzureNative.Batch.ApplicationPackage("applicationPackage", new()
 *     {
 *         AccountName = "sampleacct",
 *         ApplicationName = "app1",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         VersionName = "1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewApplicationPackage(ctx, "applicationPackage", &batch.ApplicationPackageArgs{
 * 			AccountName:       pulumi.String("sampleacct"),
 * 			ApplicationName:   pulumi.String("app1"),
 * 			ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * 			VersionName:       pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.ApplicationPackage;
 * import com.pulumi.azurenative.batch.ApplicationPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationPackage = new ApplicationPackage("applicationPackage", ApplicationPackageArgs.builder()
 *             .accountName("sampleacct")
 *             .applicationName("app1")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .versionName("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:batch:ApplicationPackage 1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}
 * ```
 */
public class ApplicationPackage internal constructor(
    override val javaResource: com.pulumi.azurenative.batch.ApplicationPackage,
) : KotlinCustomResource(javaResource, ApplicationPackageMapper) {
    /**
     * The ETag of the resource, used for concurrency statements.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The format of the application package, if the package is active.
     */
    public val format: Output<String>
        get() = javaResource.format().applyValue({ args0 -> args0 })

    /**
     * The time at which the package was last activated, if the package is active.
     */
    public val lastActivationTime: Output<String>
        get() = javaResource.lastActivationTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current state of the application package.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The URL for the application package in Azure Storage.
     */
    public val storageUrl: Output<String>
        get() = javaResource.storageUrl().applyValue({ args0 -> args0 })

    /**
     * The UTC time at which the Azure Storage URL will expire.
     */
    public val storageUrlExpiry: Output<String>
        get() = javaResource.storageUrlExpiry().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationPackageMapper : ResourceMapper<ApplicationPackage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.batch.ApplicationPackage::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationPackage = ApplicationPackage(
        javaResource as
            com.pulumi.azurenative.batch.ApplicationPackage,
    )
}

/**
 * @see [ApplicationPackage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationPackage].
 */
public suspend fun applicationPackage(
    name: String,
    block: suspend ApplicationPackageResourceBuilder.() -> Unit,
): ApplicationPackage {
    val builder = ApplicationPackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationPackage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationPackage(name: String): ApplicationPackage {
    val builder = ApplicationPackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
