@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin

import com.pulumi.azurenative.batch.kotlin.outputs.AutoStoragePropertiesResponse
import com.pulumi.azurenative.batch.kotlin.outputs.BatchAccountIdentityResponse
import com.pulumi.azurenative.batch.kotlin.outputs.EncryptionPropertiesResponse
import com.pulumi.azurenative.batch.kotlin.outputs.KeyVaultReferenceResponse
import com.pulumi.azurenative.batch.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.batch.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.batch.kotlin.outputs.VirtualMachineFamilyCoreQuotaResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.batch.kotlin.outputs.AutoStoragePropertiesResponse.Companion.toKotlin as autoStoragePropertiesResponseToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.BatchAccountIdentityResponse.Companion.toKotlin as batchAccountIdentityResponseToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.EncryptionPropertiesResponse.Companion.toKotlin as encryptionPropertiesResponseToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.KeyVaultReferenceResponse.Companion.toKotlin as keyVaultReferenceResponseToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.VirtualMachineFamilyCoreQuotaResponse.Companion.toKotlin as virtualMachineFamilyCoreQuotaResponseToKotlin

/**
 * Builder for [BatchAccount].
 */
@PulumiTagMarker
public class BatchAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BatchAccountArgs = BatchAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BatchAccountArgsBuilder.() -> Unit) {
        val builder = BatchAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BatchAccount {
        val builtJavaResource = com.pulumi.azurenative.batch.BatchAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BatchAccount(builtJavaResource)
    }
}

/**
 * Contains information about an Azure Batch account.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2017-01-01, 2022-01-01, 2023-11-01, 2024-02-01.
 * ## Example Usage
 * ### BatchAccountCreate_BYOS
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var batchAccount = new AzureNative.Batch.BatchAccount("batchAccount", new()
 *     {
 *         AccountName = "sampleacct",
 *         AutoStorage = new AzureNative.Batch.Inputs.AutoStorageBasePropertiesArgs
 *         {
 *             StorageAccountId = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage",
 *         },
 *         KeyVaultReference = new AzureNative.Batch.Inputs.KeyVaultReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample",
 *             Url = "http://sample.vault.azure.net/",
 *         },
 *         Location = "japaneast",
 *         PoolAllocationMode = AzureNative.Batch.PoolAllocationMode.UserSubscription,
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewBatchAccount(ctx, "batchAccount", &batch.BatchAccountArgs{
 * 			AccountName: pulumi.String("sampleacct"),
 * 			AutoStorage: &batch.AutoStorageBasePropertiesArgs{
 * 				StorageAccountId: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage"),
 * 			},
 * 			KeyVaultReference: &batch.KeyVaultReferenceArgs{
 * 				Id:  pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample"),
 * 				Url: pulumi.String("http://sample.vault.azure.net/"),
 * 			},
 * 			Location:           pulumi.String("japaneast"),
 * 			PoolAllocationMode: batch.PoolAllocationModeUserSubscription,
 * 			ResourceGroupName:  pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.BatchAccount;
 * import com.pulumi.azurenative.batch.BatchAccountArgs;
 * import com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs;
 * import com.pulumi.azurenative.batch.inputs.KeyVaultReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var batchAccount = new BatchAccount("batchAccount", BatchAccountArgs.builder()
 *             .accountName("sampleacct")
 *             .autoStorage(AutoStorageBasePropertiesArgs.builder()
 *                 .storageAccountId("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage")
 *                 .build())
 *             .keyVaultReference(KeyVaultReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample")
 *                 .url("http://sample.vault.azure.net/")
 *                 .build())
 *             .location("japaneast")
 *             .poolAllocationMode("UserSubscription")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ### BatchAccountCreate_Default
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var batchAccount = new AzureNative.Batch.BatchAccount("batchAccount", new()
 *     {
 *         AccountName = "sampleacct",
 *         AutoStorage = new AzureNative.Batch.Inputs.AutoStorageBasePropertiesArgs
 *         {
 *             StorageAccountId = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage",
 *         },
 *         Location = "japaneast",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewBatchAccount(ctx, "batchAccount", &batch.BatchAccountArgs{
 * 			AccountName: pulumi.String("sampleacct"),
 * 			AutoStorage: &batch.AutoStorageBasePropertiesArgs{
 * 				StorageAccountId: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage"),
 * 			},
 * 			Location:          pulumi.String("japaneast"),
 * 			ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.BatchAccount;
 * import com.pulumi.azurenative.batch.BatchAccountArgs;
 * import com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var batchAccount = new BatchAccount("batchAccount", BatchAccountArgs.builder()
 *             .accountName("sampleacct")
 *             .autoStorage(AutoStorageBasePropertiesArgs.builder()
 *                 .storageAccountId("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage")
 *                 .build())
 *             .location("japaneast")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ### BatchAccountCreate_SystemAssignedIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var batchAccount = new AzureNative.Batch.BatchAccount("batchAccount", new()
 *     {
 *         AccountName = "sampleacct",
 *         AutoStorage = new AzureNative.Batch.Inputs.AutoStorageBasePropertiesArgs
 *         {
 *             StorageAccountId = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage",
 *         },
 *         Identity = new AzureNative.Batch.Inputs.BatchAccountIdentityArgs
 *         {
 *             Type = AzureNative.Batch.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "japaneast",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewBatchAccount(ctx, "batchAccount", &batch.BatchAccountArgs{
 * 			AccountName: pulumi.String("sampleacct"),
 * 			AutoStorage: &batch.AutoStorageBasePropertiesArgs{
 * 				StorageAccountId: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage"),
 * 			},
 * 			Identity: &batch.BatchAccountIdentityArgs{
 * 				Type: batch.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location:          pulumi.String("japaneast"),
 * 			ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.BatchAccount;
 * import com.pulumi.azurenative.batch.BatchAccountArgs;
 * import com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs;
 * import com.pulumi.azurenative.batch.inputs.BatchAccountIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var batchAccount = new BatchAccount("batchAccount", BatchAccountArgs.builder()
 *             .accountName("sampleacct")
 *             .autoStorage(AutoStorageBasePropertiesArgs.builder()
 *                 .storageAccountId("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage")
 *                 .build())
 *             .identity(BatchAccountIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("japaneast")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateBatchAccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var batchAccount = new AzureNative.Batch.BatchAccount("batchAccount", new()
 *     {
 *         AccountName = "sampleacct",
 *         AutoStorage = new AzureNative.Batch.Inputs.AutoStorageBasePropertiesArgs
 *         {
 *             StorageAccountId = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage",
 *         },
 *         KeyVaultReference = new AzureNative.Batch.Inputs.KeyVaultReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample",
 *             Url = "http://sample.vault.azure.net/",
 *         },
 *         Location = "japaneast",
 *         PublicNetworkAccess = AzureNative.Batch.PublicNetworkAccessType.Disabled,
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewBatchAccount(ctx, "batchAccount", &batch.BatchAccountArgs{
 * 			AccountName: pulumi.String("sampleacct"),
 * 			AutoStorage: &batch.AutoStorageBasePropertiesArgs{
 * 				StorageAccountId: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage"),
 * 			},
 * 			KeyVaultReference: &batch.KeyVaultReferenceArgs{
 * 				Id:  pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample"),
 * 				Url: pulumi.String("http://sample.vault.azure.net/"),
 * 			},
 * 			Location:            pulumi.String("japaneast"),
 * 			PublicNetworkAccess: batch.PublicNetworkAccessTypeDisabled,
 * 			ResourceGroupName:   pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.BatchAccount;
 * import com.pulumi.azurenative.batch.BatchAccountArgs;
 * import com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs;
 * import com.pulumi.azurenative.batch.inputs.KeyVaultReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var batchAccount = new BatchAccount("batchAccount", BatchAccountArgs.builder()
 *             .accountName("sampleacct")
 *             .autoStorage(AutoStorageBasePropertiesArgs.builder()
 *                 .storageAccountId("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage")
 *                 .build())
 *             .keyVaultReference(KeyVaultReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample")
 *                 .url("http://sample.vault.azure.net/")
 *                 .build())
 *             .location("japaneast")
 *             .publicNetworkAccess("Disabled")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:batch:BatchAccount sampleacct /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}
 * ```
 */
public class BatchAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.batch.BatchAccount,
) : KotlinCustomResource(javaResource, BatchAccountMapper) {
    /**
     * The account endpoint used to interact with the Batch service.
     */
    public val accountEndpoint: Output<String>
        get() = javaResource.accountEndpoint().applyValue({ args0 -> args0 })

    public val activeJobAndJobScheduleQuota: Output<Int>
        get() = javaResource.activeJobAndJobScheduleQuota().applyValue({ args0 -> args0 })

    /**
     * List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
     */
    public val allowedAuthenticationModes: Output<List<String>>
        get() = javaResource.allowedAuthenticationModes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Contains information about the auto-storage account associated with a Batch account.
     */
    public val autoStorage: Output<AutoStoragePropertiesResponse>
        get() = javaResource.autoStorage().applyValue({ args0 ->
            args0.let({ args0 ->
                autoStoragePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * For accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription so this value is not returned.
     */
    public val dedicatedCoreQuota: Output<Int>
        get() = javaResource.dedicatedCoreQuota().applyValue({ args0 -> args0 })

    /**
     * A list of the dedicated core quota per Virtual Machine family for the Batch account. For accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription so this value is not returned.
     */
    public val dedicatedCoreQuotaPerVMFamily: Output<List<VirtualMachineFamilyCoreQuotaResponse>>
        get() = javaResource.dedicatedCoreQuotaPerVMFamily().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> virtualMachineFamilyCoreQuotaResponseToKotlin(args0) })
            })
        })

    /**
     * If this flag is true, dedicated core quota is enforced via both the dedicatedCoreQuotaPerVMFamily and dedicatedCoreQuota properties on the account. If this flag is false, dedicated core quota is enforced only via the dedicatedCoreQuota property on the account and does not consider Virtual Machine family.
     */
    public val dedicatedCoreQuotaPerVMFamilyEnforced: Output<Boolean>
        get() = javaResource.dedicatedCoreQuotaPerVMFamilyEnforced().applyValue({ args0 -> args0 })

    /**
     * Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
     */
    public val encryption: Output<EncryptionPropertiesResponse>
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.let({ args0 ->
                encryptionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The identity of the Batch account.
     */
    public val identity: Output<BatchAccountIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    batchAccountIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Identifies the Azure key vault associated with a Batch account.
     */
    public val keyVaultReference: Output<KeyVaultReferenceResponse>
        get() = javaResource.keyVaultReference().applyValue({ args0 ->
            args0.let({ args0 ->
                keyVaultReferenceResponseToKotlin(args0)
            })
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * For accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription so this value is not returned.
     */
    public val lowPriorityCoreQuota: Output<Int>
        get() = javaResource.lowPriorityCoreQuota().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network profile only takes effect when publicNetworkAccess is enabled.
     */
    public val networkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The endpoint used by compute node to connect to the Batch node management service.
     */
    public val nodeManagementEndpoint: Output<String>
        get() = javaResource.nodeManagementEndpoint().applyValue({ args0 -> args0 })

    /**
     * The allocation mode for creating pools in the Batch account.
     */
    public val poolAllocationMode: Output<String>
        get() = javaResource.poolAllocationMode().applyValue({ args0 -> args0 })

    public val poolQuota: Output<Int>
        get() = javaResource.poolQuota().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connections associated with the Batch account
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioned state of the resource
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * If not specified, the default value is 'enabled'.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BatchAccountMapper : ResourceMapper<BatchAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.batch.BatchAccount::class == javaResource::class

    override fun map(javaResource: Resource): BatchAccount = BatchAccount(
        javaResource as
            com.pulumi.azurenative.batch.BatchAccount,
    )
}

/**
 * @see [BatchAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BatchAccount].
 */
public suspend fun batchAccount(
    name: String,
    block: suspend BatchAccountResourceBuilder.() -> Unit,
): BatchAccount {
    val builder = BatchAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BatchAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun batchAccount(name: String): BatchAccount {
    val builder = BatchAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
