@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin

import com.pulumi.azurenative.batch.BatchFunctions.getApplicationPackagePlain
import com.pulumi.azurenative.batch.BatchFunctions.getApplicationPlain
import com.pulumi.azurenative.batch.BatchFunctions.getBatchAccountPlain
import com.pulumi.azurenative.batch.BatchFunctions.getPoolPlain
import com.pulumi.azurenative.batch.BatchFunctions.listBatchAccountKeysPlain
import com.pulumi.azurenative.batch.kotlin.inputs.GetApplicationPackagePlainArgs
import com.pulumi.azurenative.batch.kotlin.inputs.GetApplicationPackagePlainArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.azurenative.batch.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.GetBatchAccountPlainArgs
import com.pulumi.azurenative.batch.kotlin.inputs.GetBatchAccountPlainArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.GetPoolPlainArgs
import com.pulumi.azurenative.batch.kotlin.inputs.GetPoolPlainArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.ListBatchAccountKeysPlainArgs
import com.pulumi.azurenative.batch.kotlin.inputs.ListBatchAccountKeysPlainArgsBuilder
import com.pulumi.azurenative.batch.kotlin.outputs.GetApplicationPackageResult
import com.pulumi.azurenative.batch.kotlin.outputs.GetApplicationResult
import com.pulumi.azurenative.batch.kotlin.outputs.GetBatchAccountResult
import com.pulumi.azurenative.batch.kotlin.outputs.GetPoolResult
import com.pulumi.azurenative.batch.kotlin.outputs.ListBatchAccountKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.batch.kotlin.outputs.GetApplicationPackageResult.Companion.toKotlin as getApplicationPackageResultToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.GetBatchAccountResult.Companion.toKotlin as getBatchAccountResultToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.GetPoolResult.Companion.toKotlin as getPoolResultToKotlin
import com.pulumi.azurenative.batch.kotlin.outputs.ListBatchAccountKeysResult.Companion.toKotlin as listBatchAccountKeysResultToKotlin

public object BatchFunctions {
    /**
     * Gets information about the specified application.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2017-09-01, 2023-11-01, 2024-02-01.
     * @param argument null
     * @return Contains information about an application in a Batch account.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @return Contains information about an application in a Batch account.
     */
    public suspend fun getApplication(
        accountName: String,
        applicationName: String,
        resourceGroupName: String,
    ): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            accountName = accountName,
            applicationName = applicationName,
            resourceGroupName = resourceGroupName,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;batch&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return Contains information about an application in a Batch account.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit): GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified application package.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2017-09-01, 2023-11-01, 2024-02-01.
     * @param argument null
     * @return An application package which represents a particular version of an application.
     */
    public suspend fun getApplicationPackage(argument: GetApplicationPackagePlainArgs): GetApplicationPackageResult =
        getApplicationPackageResultToKotlin(getApplicationPackagePlain(argument.toJava()).await())

    /**
     * @see [getApplicationPackage].
     * @param accountName The name of the Batch account.
     * @param applicationName The name of the application. This must be unique within the account.
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param versionName The version of the application.
     * @return An application package which represents a particular version of an application.
     */
    public suspend fun getApplicationPackage(
        accountName: String,
        applicationName: String,
        resourceGroupName: String,
        versionName: String,
    ): GetApplicationPackageResult {
        val argument = GetApplicationPackagePlainArgs(
            accountName = accountName,
            applicationName = applicationName,
            resourceGroupName = resourceGroupName,
            versionName = versionName,
        )
        return getApplicationPackageResultToKotlin(getApplicationPackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationPackage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;batch&#46;kotlin&#46;inputs&#46;GetApplicationPackagePlainArgs].
     * @return An application package which represents a particular version of an application.
     */
    public suspend fun getApplicationPackage(argument: suspend GetApplicationPackagePlainArgsBuilder.() -> Unit): GetApplicationPackageResult {
        val builder = GetApplicationPackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationPackageResultToKotlin(getApplicationPackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified Batch account.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2017-01-01, 2022-01-01, 2023-11-01, 2024-02-01.
     * @param argument null
     * @return Contains information about an Azure Batch account.
     */
    public suspend fun getBatchAccount(argument: GetBatchAccountPlainArgs): GetBatchAccountResult =
        getBatchAccountResultToKotlin(getBatchAccountPlain(argument.toJava()).await())

    /**
     * @see [getBatchAccount].
     * @param accountName The name of the Batch account.
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @return Contains information about an Azure Batch account.
     */
    public suspend fun getBatchAccount(accountName: String, resourceGroupName: String): GetBatchAccountResult {
        val argument = GetBatchAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getBatchAccountResultToKotlin(getBatchAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getBatchAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;batch&#46;kotlin&#46;inputs&#46;GetBatchAccountPlainArgs].
     * @return Contains information about an Azure Batch account.
     */
    public suspend fun getBatchAccount(argument: suspend GetBatchAccountPlainArgsBuilder.() -> Unit): GetBatchAccountResult {
        val builder = GetBatchAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBatchAccountResultToKotlin(getBatchAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified pool.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2020-05-01, 2023-11-01, 2024-02-01.
     * @param argument null
     * @return Contains information about a pool.
     */
    public suspend fun getPool(argument: GetPoolPlainArgs): GetPoolResult =
        getPoolResultToKotlin(getPoolPlain(argument.toJava()).await())

    /**
     * @see [getPool].
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @return Contains information about a pool.
     */
    public suspend fun getPool(
        accountName: String,
        poolName: String,
        resourceGroupName: String,
    ): GetPoolResult {
        val argument = GetPoolPlainArgs(
            accountName = accountName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
        )
        return getPoolResultToKotlin(getPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;batch&#46;kotlin&#46;inputs&#46;GetPoolPlainArgs].
     * @return Contains information about a pool.
     */
    public suspend fun getPool(argument: suspend GetPoolPlainArgsBuilder.() -> Unit): GetPoolResult {
        val builder = GetPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPoolResultToKotlin(getPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * This operation applies only to Batch accounts with allowedAuthenticationModes containing 'SharedKey'. If the Batch account doesn't contain 'SharedKey' in its allowedAuthenticationMode, clients cannot use shared keys to authenticate, and must use another allowedAuthenticationModes instead. In this case, getting the keys will fail.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2017-01-01, 2022-01-01, 2023-11-01, 2024-02-01.
     * @param argument null
     * @return A set of Azure Batch account keys.
     */
    public suspend fun listBatchAccountKeys(argument: ListBatchAccountKeysPlainArgs): ListBatchAccountKeysResult =
        listBatchAccountKeysResultToKotlin(listBatchAccountKeysPlain(argument.toJava()).await())

    /**
     * @see [listBatchAccountKeys].
     * @param accountName The name of the Batch account.
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @return A set of Azure Batch account keys.
     */
    public suspend fun listBatchAccountKeys(accountName: String, resourceGroupName: String): ListBatchAccountKeysResult {
        val argument = ListBatchAccountKeysPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return listBatchAccountKeysResultToKotlin(listBatchAccountKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listBatchAccountKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;batch&#46;kotlin&#46;inputs&#46;ListBatchAccountKeysPlainArgs].
     * @return A set of Azure Batch account keys.
     */
    public suspend fun listBatchAccountKeys(argument: suspend ListBatchAccountKeysPlainArgsBuilder.() -> Unit): ListBatchAccountKeysResult {
        val builder = ListBatchAccountKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listBatchAccountKeysResultToKotlin(listBatchAccountKeysPlain(builtArgument.toJava()).await())
    }
}
