@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication mode for the Batch account.
 */
public enum class AuthenticationMode(
    public val javaValue: com.pulumi.azurenative.batch.enums.AuthenticationMode,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.AuthenticationMode> {
    /**
     * The authentication mode using shared keys.
     */
    SharedKey(com.pulumi.azurenative.batch.enums.AuthenticationMode.SharedKey),

    /**
     * The authentication mode using Azure Active Directory.
     */
    AAD(com.pulumi.azurenative.batch.enums.AuthenticationMode.AAD),

    /**
     * The authentication mode using task authentication tokens.
     */
    TaskAuthenticationToken(com.pulumi.azurenative.batch.enums.AuthenticationMode.TaskAuthenticationToken),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.AuthenticationMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.AuthenticationMode): AuthenticationMode = AuthenticationMode.values().first { it.javaValue == javaType }
    }
}
