@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
 */
public enum class CertificateStoreLocation(
    public val javaValue: com.pulumi.azurenative.batch.enums.CertificateStoreLocation,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.CertificateStoreLocation> {
    /**
     * Certificates should be installed to the CurrentUser certificate store.
     */
    CurrentUser(com.pulumi.azurenative.batch.enums.CertificateStoreLocation.CurrentUser),

    /**
     * Certificates should be installed to the LocalMachine certificate store.
     */
    LocalMachine(com.pulumi.azurenative.batch.enums.CertificateStoreLocation.LocalMachine),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.CertificateStoreLocation = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.CertificateStoreLocation): CertificateStoreLocation =
            CertificateStoreLocation.values().first { it.javaValue == javaType }
    }
}
