@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

public enum class CertificateVisibility(
    public val javaValue: com.pulumi.azurenative.batch.enums.CertificateVisibility,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.CertificateVisibility> {
    /**
     * The certificate should be visible to the user account under which the start task is run. Note that if AutoUser Scope is Pool for both the StartTask and a Task, this certificate will be visible to the Task as well.
     */
    StartTask(com.pulumi.azurenative.batch.enums.CertificateVisibility.StartTask),

    /**
     * The certificate should be visible to the user accounts under which job tasks are run.
     */
    Task(com.pulumi.azurenative.batch.enums.CertificateVisibility.Task),

    /**
     * The certificate should be visible to the user accounts under which users remotely access the node.
     */
    RemoteUser(com.pulumi.azurenative.batch.enums.CertificateVisibility.RemoteUser),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.CertificateVisibility = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.CertificateVisibility): CertificateVisibility = CertificateVisibility.values().first { it.javaValue == javaType }
    }
}
