@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

public enum class ComputeNodeFillType(
    public val javaValue: com.pulumi.azurenative.batch.enums.ComputeNodeFillType,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.ComputeNodeFillType> {
    /**
     * Tasks should be assigned evenly across all nodes in the pool.
     */
    Spread(com.pulumi.azurenative.batch.enums.ComputeNodeFillType.Spread),

    /**
     * As many tasks as possible (taskSlotsPerNode) should be assigned to each node in the pool before any tasks are assigned to the next node in the pool.
     */
    Pack(com.pulumi.azurenative.batch.enums.ComputeNodeFillType.Pack),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.ComputeNodeFillType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.ComputeNodeFillType): ComputeNodeFillType = ComputeNodeFillType.values().first { it.javaValue == javaType }
    }
}
