@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

public enum class ContainerWorkingDirectory(
    public val javaValue: com.pulumi.azurenative.batch.enums.ContainerWorkingDirectory,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.ContainerWorkingDirectory> {
    /**
     * Use the standard Batch service task working directory, which will contain the Task resource files populated by Batch.
     */
    TaskWorkingDirectory(com.pulumi.azurenative.batch.enums.ContainerWorkingDirectory.TaskWorkingDirectory),

    /**
     * Using container image defined working directory. Beware that this directory will not contain the resource files downloaded by Batch.
     */
    ContainerImageDefault(com.pulumi.azurenative.batch.enums.ContainerWorkingDirectory.ContainerImageDefault),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.ContainerWorkingDirectory = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.ContainerWorkingDirectory): ContainerWorkingDirectory =
            ContainerWorkingDirectory.values().first { it.javaValue == javaType }
    }
}
