@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
 */
public enum class EndpointAccessDefaultAction(
    public val javaValue: com.pulumi.azurenative.batch.enums.EndpointAccessDefaultAction,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.EndpointAccessDefaultAction> {
    /**
     * Allow client access.
     */
    Allow(com.pulumi.azurenative.batch.enums.EndpointAccessDefaultAction.Allow),

    /**
     * Deny client access.
     */
    Deny(com.pulumi.azurenative.batch.enums.EndpointAccessDefaultAction.Deny),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.EndpointAccessDefaultAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.EndpointAccessDefaultAction): EndpointAccessDefaultAction =
            EndpointAccessDefaultAction.values().first { it.javaValue == javaType }
    }
}
