@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to 'Disabled'.
 */
public enum class InterNodeCommunicationState(
    public val javaValue: com.pulumi.azurenative.batch.enums.InterNodeCommunicationState,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.InterNodeCommunicationState> {
    /**
     * Enable network communication between virtual machines.
     */
    Enabled(com.pulumi.azurenative.batch.enums.InterNodeCommunicationState.Enabled),

    /**
     * Disable network communication between virtual machines.
     */
    Disabled(com.pulumi.azurenative.batch.enums.InterNodeCommunicationState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.InterNodeCommunicationState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.InterNodeCommunicationState): InterNodeCommunicationState =
            InterNodeCommunicationState.values().first { it.javaValue == javaType }
    }
}
