@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy.
 */
public enum class NodePlacementPolicyType(
    public val javaValue: com.pulumi.azurenative.batch.enums.NodePlacementPolicyType,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.NodePlacementPolicyType> {
    /**
     * All nodes in the pool will be allocated in the same region.
     */
    Regional(com.pulumi.azurenative.batch.enums.NodePlacementPolicyType.Regional),

    /**
     * Nodes in the pool will be spread across different zones with best effort balancing.
     */
    Zonal(com.pulumi.azurenative.batch.enums.NodePlacementPolicyType.Zonal),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.NodePlacementPolicyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.NodePlacementPolicyType): NodePlacementPolicyType =
            NodePlacementPolicyType.values().first { it.javaValue == javaType }
    }
}
