@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the Batch Pool.
 */
public enum class PoolIdentityType(
    public val javaValue: com.pulumi.azurenative.batch.enums.PoolIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.PoolIdentityType> {
    /**
     * Batch pool has user assigned identities with it.
     */
    UserAssigned(com.pulumi.azurenative.batch.enums.PoolIdentityType.UserAssigned),

    /**
     * Batch pool has no identity associated with it. Setting `None` in update pool will remove existing identities.
     */
    None(com.pulumi.azurenative.batch.enums.PoolIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.PoolIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.PoolIdentityType): PoolIdentityType = PoolIdentityType.values().first { it.javaValue == javaType }
    }
}
