@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the Batch account.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.batch.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.ResourceIdentityType> {
    /**
     * Batch account has a system assigned identity with it.
     */
    SystemAssigned(com.pulumi.azurenative.batch.enums.ResourceIdentityType.SystemAssigned),

    /**
     * Batch account has user assigned identities with it.
     */
    UserAssigned(com.pulumi.azurenative.batch.enums.ResourceIdentityType.UserAssigned),

    /**
     * Batch account has no identity associated with it. Setting `None` in update account will remove existing identities.
     */
    None(com.pulumi.azurenative.batch.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
