@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.ApplicationPackageReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id
 * @property version If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
 */
public data class ApplicationPackageReferenceArgs(
    public val id: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.ApplicationPackageReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.ApplicationPackageReferenceArgs =
        com.pulumi.azurenative.batch.inputs.ApplicationPackageReferenceArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationPackageReferenceArgs].
 */
@PulumiTagMarker
public class ApplicationPackageReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("rlipqansubgdgnoo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
     */
    @JvmName("ughiorgqkkxegiih")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value
     */
    @JvmName("ovmeyodtfhmnyevc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
     */
    @JvmName("uvwhsenbxviacbra")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ApplicationPackageReferenceArgs = ApplicationPackageReferenceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        version = version,
    )
}
