@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.AzureBlobFileSystemConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accountKey This property is mutually exclusive with both sasKey and identity; exactly one must be specified.
 * @property accountName
 * @property blobfuseOptions These are 'net use' options in Windows and 'mount' options in Linux.
 * @property containerName
 * @property identityReference This property is mutually exclusive with both accountKey and sasKey; exactly one must be specified.
 * @property relativeMountPath All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
 * @property sasKey This property is mutually exclusive with both accountKey and identity; exactly one must be specified.
 */
public data class AzureBlobFileSystemConfigurationArgs(
    public val accountKey: Output<String>? = null,
    public val accountName: Output<String>,
    public val blobfuseOptions: Output<String>? = null,
    public val containerName: Output<String>,
    public val identityReference: Output<ComputeNodeIdentityReferenceArgs>? = null,
    public val relativeMountPath: Output<String>,
    public val sasKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.AzureBlobFileSystemConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.AzureBlobFileSystemConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.AzureBlobFileSystemConfigurationArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0 }))
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .blobfuseOptions(blobfuseOptions?.applyValue({ args0 -> args0 }))
            .containerName(containerName.applyValue({ args0 -> args0 }))
            .identityReference(identityReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .relativeMountPath(relativeMountPath.applyValue({ args0 -> args0 }))
            .sasKey(sasKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBlobFileSystemConfigurationArgs].
 */
@PulumiTagMarker
public class AzureBlobFileSystemConfigurationArgsBuilder internal constructor() {
    private var accountKey: Output<String>? = null

    private var accountName: Output<String>? = null

    private var blobfuseOptions: Output<String>? = null

    private var containerName: Output<String>? = null

    private var identityReference: Output<ComputeNodeIdentityReferenceArgs>? = null

    private var relativeMountPath: Output<String>? = null

    private var sasKey: Output<String>? = null

    /**
     * @param value This property is mutually exclusive with both sasKey and identity; exactly one must be specified.
     */
    @JvmName("cfypjlmaqweptwtj")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value
     */
    @JvmName("mrdxkcvlleqbtqxt")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value These are 'net use' options in Windows and 'mount' options in Linux.
     */
    @JvmName("uaidhfskbnmgrmrt")
    public suspend fun blobfuseOptions(`value`: Output<String>) {
        this.blobfuseOptions = value
    }

    /**
     * @param value
     */
    @JvmName("dnrpaglerxwxtymj")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value This property is mutually exclusive with both accountKey and sasKey; exactly one must be specified.
     */
    @JvmName("rbggvkualydeybnk")
    public suspend fun identityReference(`value`: Output<ComputeNodeIdentityReferenceArgs>) {
        this.identityReference = value
    }

    /**
     * @param value All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     */
    @JvmName("xhdrolpgylyrwspd")
    public suspend fun relativeMountPath(`value`: Output<String>) {
        this.relativeMountPath = value
    }

    /**
     * @param value This property is mutually exclusive with both accountKey and identity; exactly one must be specified.
     */
    @JvmName("xwpdgbgwqrufyskb")
    public suspend fun sasKey(`value`: Output<String>) {
        this.sasKey = value
    }

    /**
     * @param value This property is mutually exclusive with both sasKey and identity; exactly one must be specified.
     */
    @JvmName("bvchbdgawagdumeb")
    public suspend fun accountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value
     */
    @JvmName("riswjsmaousmcggr")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value These are 'net use' options in Windows and 'mount' options in Linux.
     */
    @JvmName("obtywvpfbfxmvygw")
    public suspend fun blobfuseOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobfuseOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("xnwwbgelysmogxpe")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value This property is mutually exclusive with both accountKey and sasKey; exactly one must be specified.
     */
    @JvmName("yenjmlkpphqgchtk")
    public suspend fun identityReference(`value`: ComputeNodeIdentityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityReference = mapped
    }

    /**
     * @param argument This property is mutually exclusive with both accountKey and sasKey; exactly one must be specified.
     */
    @JvmName("inbennojckkolwhi")
    public suspend fun identityReference(argument: suspend ComputeNodeIdentityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeNodeIdentityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityReference = mapped
    }

    /**
     * @param value All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     */
    @JvmName("qacwfsggbqcfjoay")
    public suspend fun relativeMountPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relativeMountPath = mapped
    }

    /**
     * @param value This property is mutually exclusive with both accountKey and identity; exactly one must be specified.
     */
    @JvmName("ifnfdbbseukdwyta")
    public suspend fun sasKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasKey = mapped
    }

    internal fun build(): AzureBlobFileSystemConfigurationArgs = AzureBlobFileSystemConfigurationArgs(
        accountKey = accountKey,
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        blobfuseOptions = blobfuseOptions,
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        identityReference = identityReference,
        relativeMountPath = relativeMountPath ?: throw PulumiNullFieldException("relativeMountPath"),
        sasKey = sasKey,
    )
}
