@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.CertificateReferenceArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.CertificateStoreLocation
import com.pulumi.azurenative.batch.kotlin.enums.CertificateVisibility
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Warning: This object is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
 * @property id
 * @property storeLocation The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
 * @property storeName This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
 * @property visibility
 */
public data class CertificateReferenceArgs(
    public val id: Output<String>,
    public val storeLocation: Output<CertificateStoreLocation>? = null,
    public val storeName: Output<String>? = null,
    public val visibility: Output<List<CertificateVisibility>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.CertificateReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.CertificateReferenceArgs =
        com.pulumi.azurenative.batch.inputs.CertificateReferenceArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .storeLocation(storeLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storeName(storeName?.applyValue({ args0 -> args0 }))
            .visibility(
                visibility?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CertificateReferenceArgs].
 */
@PulumiTagMarker
public class CertificateReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var storeLocation: Output<CertificateStoreLocation>? = null

    private var storeName: Output<String>? = null

    private var visibility: Output<List<CertificateVisibility>>? = null

    /**
     * @param value
     */
    @JvmName("akmvbgbmbrefchxc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     */
    @JvmName("imnomejpkbuskrof")
    public suspend fun storeLocation(`value`: Output<CertificateStoreLocation>) {
        this.storeLocation = value
    }

    /**
     * @param value This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
     */
    @JvmName("jrkaetrpkjtjuerj")
    public suspend fun storeName(`value`: Output<String>) {
        this.storeName = value
    }

    /**
     * @param value
     */
    @JvmName("lljhwpnxyorwyuuu")
    public suspend fun visibility(`value`: Output<List<CertificateVisibility>>) {
        this.visibility = value
    }

    @JvmName("bxnivvnrnwtgbups")
    public suspend fun visibility(vararg values: Output<CertificateVisibility>) {
        this.visibility = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("utqigxwlvcnrrwby")
    public suspend fun visibility(values: List<Output<CertificateVisibility>>) {
        this.visibility = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("sklubjqkbwrkmkmi")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     */
    @JvmName("ucobvttebvkbvfst")
    public suspend fun storeLocation(`value`: CertificateStoreLocation?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeLocation = mapped
    }

    /**
     * @param value This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
     */
    @JvmName("cavabgmwgnupafyc")
    public suspend fun storeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeName = mapped
    }

    /**
     * @param value
     */
    @JvmName("wwxrymbvtutaxsvq")
    public suspend fun visibility(`value`: List<CertificateVisibility>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param values
     */
    @JvmName("yxvwpyqkhinmlryk")
    public suspend fun visibility(vararg values: CertificateVisibility) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    internal fun build(): CertificateReferenceArgs = CertificateReferenceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        storeLocation = storeLocation,
        storeName = storeName,
        visibility = visibility,
    )
}
