@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.GetPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Batch account.
 * @property poolName The pool name. This must be unique within the account.
 * @property resourceGroupName The name of the resource group that contains the Batch account.
 */
public data class GetPoolPlainArgs(
    public val accountName: String,
    public val poolName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.GetPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.GetPoolPlainArgs =
        com.pulumi.azurenative.batch.inputs.GetPoolPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPoolPlainArgs].
 */
@PulumiTagMarker
public class GetPoolPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var poolName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Batch account.
     */
    @JvmName("chnvmftcdbrjogci")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The pool name. This must be unique within the account.
     */
    @JvmName("ujmyoiqygrnsptsc")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("unklmsigssftuilg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPoolPlainArgs = GetPoolPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
