@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.NetworkConfigurationArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.DynamicVNetAssignmentScope
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The network configuration for a pool.
 * @property dynamicVnetAssignmentScope
 * @property enableAcceleratedNetworking Accelerated networking enables single root I/O virtualization (SR-IOV) to a VM, which may lead to improved networking performance. For more details, see: https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
 * @property endpointConfiguration Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
 * @property publicIPAddressConfiguration This property is only supported on Pools with the virtualMachineConfiguration property.
 * @property subnetId The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
 */
public data class NetworkConfigurationArgs(
    public val dynamicVnetAssignmentScope: Output<DynamicVNetAssignmentScope>? = null,
    public val enableAcceleratedNetworking: Output<Boolean>? = null,
    public val endpointConfiguration: Output<PoolEndpointConfigurationArgs>? = null,
    public val publicIPAddressConfiguration: Output<PublicIPAddressConfigurationArgs>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.NetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.NetworkConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.NetworkConfigurationArgs.builder()
            .dynamicVnetAssignmentScope(
                dynamicVnetAssignmentScope?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enableAcceleratedNetworking(enableAcceleratedNetworking?.applyValue({ args0 -> args0 }))
            .endpointConfiguration(
                endpointConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicIPAddressConfiguration(
                publicIPAddressConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkConfigurationArgsBuilder internal constructor() {
    private var dynamicVnetAssignmentScope: Output<DynamicVNetAssignmentScope>? = null

    private var enableAcceleratedNetworking: Output<Boolean>? = null

    private var endpointConfiguration: Output<PoolEndpointConfigurationArgs>? = null

    private var publicIPAddressConfiguration: Output<PublicIPAddressConfigurationArgs>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("msacvsdtwqqcarlg")
    public suspend fun dynamicVnetAssignmentScope(`value`: Output<DynamicVNetAssignmentScope>) {
        this.dynamicVnetAssignmentScope = value
    }

    /**
     * @param value Accelerated networking enables single root I/O virtualization (SR-IOV) to a VM, which may lead to improved networking performance. For more details, see: https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
     */
    @JvmName("ijxseaxbdaqnfuvo")
    public suspend fun enableAcceleratedNetworking(`value`: Output<Boolean>) {
        this.enableAcceleratedNetworking = value
    }

    /**
     * @param value Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
     */
    @JvmName("umrgyevxqsawfvxe")
    public suspend fun endpointConfiguration(`value`: Output<PoolEndpointConfigurationArgs>) {
        this.endpointConfiguration = value
    }

    /**
     * @param value This property is only supported on Pools with the virtualMachineConfiguration property.
     */
    @JvmName("qgnmpkietlqtgdcl")
    public suspend fun publicIPAddressConfiguration(`value`: Output<PublicIPAddressConfigurationArgs>) {
        this.publicIPAddressConfiguration = value
    }

    /**
     * @param value The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
     */
    @JvmName("pfslwdgvqjvswbwb")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value
     */
    @JvmName("fsyhgumetwerspxm")
    public suspend fun dynamicVnetAssignmentScope(`value`: DynamicVNetAssignmentScope?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicVnetAssignmentScope = mapped
    }

    /**
     * @param value Accelerated networking enables single root I/O virtualization (SR-IOV) to a VM, which may lead to improved networking performance. For more details, see: https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
     */
    @JvmName("bldculusiwepxgsq")
    public suspend fun enableAcceleratedNetworking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAcceleratedNetworking = mapped
    }

    /**
     * @param value Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
     */
    @JvmName("xcpncobgcvkvbwhw")
    public suspend fun endpointConfiguration(`value`: PoolEndpointConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointConfiguration = mapped
    }

    /**
     * @param argument Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
     */
    @JvmName("ciumexsdmglshsvp")
    public suspend fun endpointConfiguration(argument: suspend PoolEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PoolEndpointConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointConfiguration = mapped
    }

    /**
     * @param value This property is only supported on Pools with the virtualMachineConfiguration property.
     */
    @JvmName("eityqqtioxgxocrk")
    public suspend fun publicIPAddressConfiguration(`value`: PublicIPAddressConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddressConfiguration = mapped
    }

    /**
     * @param argument This property is only supported on Pools with the virtualMachineConfiguration property.
     */
    @JvmName("bnmioxgxvukyvfyo")
    public suspend fun publicIPAddressConfiguration(argument: suspend PublicIPAddressConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddressConfiguration = mapped
    }

    /**
     * @param value The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
     */
    @JvmName("rgkjdafcavrtgblp")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): NetworkConfigurationArgs = NetworkConfigurationArgs(
        dynamicVnetAssignmentScope = dynamicVnetAssignmentScope,
        enableAcceleratedNetworking = enableAcceleratedNetworking,
        endpointConfiguration = endpointConfiguration,
        publicIPAddressConfiguration = publicIPAddressConfiguration,
        subnetId = subnetId,
    )
}
