@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.ResourceFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoStorageContainerName The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
 * @property blobPrefix The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
 * @property fileMode This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
 * @property filePath If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
 * @property httpUrl The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL points to Azure Blob Storage, it must be readable from compute nodes. There are three ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, use a managed identity with read permission, or set the ACL for the blob or its container to allow public access.
 * @property identityReference The reference to a user assigned identity associated with the Batch pool which a compute node will use.
 * @property storageContainerUrl The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable from compute nodes. There are three ways to get such a URL for a container in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the container, use a managed identity with read and list permissions, or set the ACL for the container to allow public access.
 */
public data class ResourceFileArgs(
    public val autoStorageContainerName: Output<String>? = null,
    public val blobPrefix: Output<String>? = null,
    public val fileMode: Output<String>? = null,
    public val filePath: Output<String>? = null,
    public val httpUrl: Output<String>? = null,
    public val identityReference: Output<ComputeNodeIdentityReferenceArgs>? = null,
    public val storageContainerUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.ResourceFileArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.ResourceFileArgs =
        com.pulumi.azurenative.batch.inputs.ResourceFileArgs.builder()
            .autoStorageContainerName(autoStorageContainerName?.applyValue({ args0 -> args0 }))
            .blobPrefix(blobPrefix?.applyValue({ args0 -> args0 }))
            .fileMode(fileMode?.applyValue({ args0 -> args0 }))
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .httpUrl(httpUrl?.applyValue({ args0 -> args0 }))
            .identityReference(identityReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageContainerUrl(storageContainerUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceFileArgs].
 */
@PulumiTagMarker
public class ResourceFileArgsBuilder internal constructor() {
    private var autoStorageContainerName: Output<String>? = null

    private var blobPrefix: Output<String>? = null

    private var fileMode: Output<String>? = null

    private var filePath: Output<String>? = null

    private var httpUrl: Output<String>? = null

    private var identityReference: Output<ComputeNodeIdentityReferenceArgs>? = null

    private var storageContainerUrl: Output<String>? = null

    /**
     * @param value The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
     */
    @JvmName("hevaemtrmrxsaghc")
    public suspend fun autoStorageContainerName(`value`: Output<String>) {
        this.autoStorageContainerName = value
    }

    /**
     * @param value The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
     */
    @JvmName("qdcetmugluwcodxl")
    public suspend fun blobPrefix(`value`: Output<String>) {
        this.blobPrefix = value
    }

    /**
     * @param value This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
     */
    @JvmName("ayeaoepmucnsfmbx")
    public suspend fun fileMode(`value`: Output<String>) {
        this.fileMode = value
    }

    /**
     * @param value If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
     */
    @JvmName("vlqkqgckcnjttlrw")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL points to Azure Blob Storage, it must be readable from compute nodes. There are three ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, use a managed identity with read permission, or set the ACL for the blob or its container to allow public access.
     */
    @JvmName("wxvgcedcmhkrehpn")
    public suspend fun httpUrl(`value`: Output<String>) {
        this.httpUrl = value
    }

    /**
     * @param value The reference to a user assigned identity associated with the Batch pool which a compute node will use.
     */
    @JvmName("aebxvvbddwonqbbj")
    public suspend fun identityReference(`value`: Output<ComputeNodeIdentityReferenceArgs>) {
        this.identityReference = value
    }

    /**
     * @param value The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable from compute nodes. There are three ways to get such a URL for a container in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the container, use a managed identity with read and list permissions, or set the ACL for the container to allow public access.
     */
    @JvmName("xxtjnklogengxpcx")
    public suspend fun storageContainerUrl(`value`: Output<String>) {
        this.storageContainerUrl = value
    }

    /**
     * @param value The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
     */
    @JvmName("yjposauinckhxmxi")
    public suspend fun autoStorageContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoStorageContainerName = mapped
    }

    /**
     * @param value The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
     */
    @JvmName("jiootsbhafvdlswe")
    public suspend fun blobPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPrefix = mapped
    }

    /**
     * @param value This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
     */
    @JvmName("rfqcjfdfwbbokpqs")
    public suspend fun fileMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileMode = mapped
    }

    /**
     * @param value If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
     */
    @JvmName("kqnmuoujwrpyxxmi")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL points to Azure Blob Storage, it must be readable from compute nodes. There are three ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, use a managed identity with read permission, or set the ACL for the blob or its container to allow public access.
     */
    @JvmName("ynvalqqjbtdtpcyy")
    public suspend fun httpUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpUrl = mapped
    }

    /**
     * @param value The reference to a user assigned identity associated with the Batch pool which a compute node will use.
     */
    @JvmName("hjujuceltlpmwwgx")
    public suspend fun identityReference(`value`: ComputeNodeIdentityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityReference = mapped
    }

    /**
     * @param argument The reference to a user assigned identity associated with the Batch pool which a compute node will use.
     */
    @JvmName("ynjkmbqshcfclbtj")
    public suspend fun identityReference(argument: suspend ComputeNodeIdentityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeNodeIdentityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityReference = mapped
    }

    /**
     * @param value The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable from compute nodes. There are three ways to get such a URL for a container in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the container, use a managed identity with read and list permissions, or set the ACL for the container to allow public access.
     */
    @JvmName("tqauobnkffeyjjrt")
    public suspend fun storageContainerUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerUrl = mapped
    }

    internal fun build(): ResourceFileArgs = ResourceFileArgs(
        autoStorageContainerName = autoStorageContainerName,
        blobPrefix = blobPrefix,
        fileMode = fileMode,
        filePath = filePath,
        httpUrl = httpUrl,
        identityReference = identityReference,
        storageContainerUrl = storageContainerUrl,
    )
}
