@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.TaskContainerSettingsArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.ContainerWorkingDirectory
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property containerRunOptions These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
 * @property imageName This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
 * @property registry This setting can be omitted if was already provided at pool creation.
 * @property workingDirectory
 */
public data class TaskContainerSettingsArgs(
    public val containerRunOptions: Output<String>? = null,
    public val imageName: Output<String>,
    public val registry: Output<ContainerRegistryArgs>? = null,
    public val workingDirectory: Output<ContainerWorkingDirectory>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.TaskContainerSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.TaskContainerSettingsArgs =
        com.pulumi.azurenative.batch.inputs.TaskContainerSettingsArgs.builder()
            .containerRunOptions(containerRunOptions?.applyValue({ args0 -> args0 }))
            .imageName(imageName.applyValue({ args0 -> args0 }))
            .registry(registry?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workingDirectory(
                workingDirectory?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TaskContainerSettingsArgs].
 */
@PulumiTagMarker
public class TaskContainerSettingsArgsBuilder internal constructor() {
    private var containerRunOptions: Output<String>? = null

    private var imageName: Output<String>? = null

    private var registry: Output<ContainerRegistryArgs>? = null

    private var workingDirectory: Output<ContainerWorkingDirectory>? = null

    /**
     * @param value These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
     */
    @JvmName("huoirrctxcuhsfgc")
    public suspend fun containerRunOptions(`value`: Output<String>) {
        this.containerRunOptions = value
    }

    /**
     * @param value This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
     */
    @JvmName("galirfovgqugyefg")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value This setting can be omitted if was already provided at pool creation.
     */
    @JvmName("wleoaxxsgmuagevq")
    public suspend fun registry(`value`: Output<ContainerRegistryArgs>) {
        this.registry = value
    }

    /**
     * @param value
     */
    @JvmName("ivavvdrhkrbvoyvk")
    public suspend fun workingDirectory(`value`: Output<ContainerWorkingDirectory>) {
        this.workingDirectory = value
    }

    /**
     * @param value These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
     */
    @JvmName("rooyvtvquyoqobny")
    public suspend fun containerRunOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRunOptions = mapped
    }

    /**
     * @param value This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
     */
    @JvmName("ehaiwpkcgxsgbpvn")
    public suspend fun imageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value This setting can be omitted if was already provided at pool creation.
     */
    @JvmName("peoxagnlmvwfbhte")
    public suspend fun registry(`value`: ContainerRegistryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registry = mapped
    }

    /**
     * @param argument This setting can be omitted if was already provided at pool creation.
     */
    @JvmName("bqluftkutrxofmjm")
    public suspend fun registry(argument: suspend ContainerRegistryArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerRegistryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registry = mapped
    }

    /**
     * @param value
     */
    @JvmName("ewjrxwtjjmlvesmt")
    public suspend fun workingDirectory(`value`: ContainerWorkingDirectory?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workingDirectory = mapped
    }

    internal fun build(): TaskContainerSettingsArgs = TaskContainerSettingsArgs(
        containerRunOptions = containerRunOptions,
        imageName = imageName ?: throw PulumiNullFieldException("imageName"),
        registry = registry,
        workingDirectory = workingDirectory,
    )
}
