@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.WindowsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableAutomaticUpdates If omitted, the default value is true.
 */
public data class WindowsConfigurationArgs(
    public val enableAutomaticUpdates: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.WindowsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.WindowsConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.WindowsConfigurationArgs.builder()
            .enableAutomaticUpdates(enableAutomaticUpdates?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WindowsConfigurationArgs].
 */
@PulumiTagMarker
public class WindowsConfigurationArgsBuilder internal constructor() {
    private var enableAutomaticUpdates: Output<Boolean>? = null

    /**
     * @param value If omitted, the default value is true.
     */
    @JvmName("axnwjaauscbcgnrj")
    public suspend fun enableAutomaticUpdates(`value`: Output<Boolean>) {
        this.enableAutomaticUpdates = value
    }

    /**
     * @param value If omitted, the default value is true.
     */
    @JvmName("wfvykiignhvccrat")
    public suspend fun enableAutomaticUpdates(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpdates = mapped
    }

    internal fun build(): WindowsConfigurationArgs = WindowsConfigurationArgs(
        enableAutomaticUpdates = enableAutomaticUpdates,
    )
}
