@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id
 * @property version If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
 */
public data class ApplicationPackageReferenceResponse(
    public val id: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.ApplicationPackageReferenceResponse): ApplicationPackageReferenceResponse = ApplicationPackageReferenceResponse(
            id = javaType.id(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
