@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property code An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
 * @property details
 * @property message A message describing the error, intended to be suitable for display in a user interface.
 */
public data class AutoScaleRunErrorResponse(
    public val code: String,
    public val details: List<AutoScaleRunErrorResponse>? = null,
    public val message: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.AutoScaleRunErrorResponse): AutoScaleRunErrorResponse = AutoScaleRunErrorResponse(
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.AutoScaleRunErrorResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
        )
    }
}
