@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property error
 * @property evaluationTime
 * @property results Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
 */
public data class AutoScaleRunResponse(
    public val error: AutoScaleRunErrorResponse? = null,
    public val evaluationTime: String,
    public val results: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.AutoScaleRunResponse): AutoScaleRunResponse = AutoScaleRunResponse(
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.AutoScaleRunErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            evaluationTime = javaType.evaluationTime(),
            results = javaType.results().map({ args0 -> args0 }).orElse(null),
        )
    }
}
